#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//metaballs coloredMod01.fsh   by  grevel
//https://www.shadertoy.com/view/7sS3Rw
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//click LMB to make them shine


// number of balls
#define nBalls 15


uint Hash(uint s)
{
    s ^= 2747636419u;
    s *= 2654435769u;
    s ^= s >> 16;
    s *= 2654435769u;
    s ^= s >> 16;
    s *= 2654435769u;
    return s;
}

float r(uint seed)  // random numbers
{
    return float(Hash(seed)) / 4294967295.0; // 2^32-1
}

float interpolate(float a, float b, float d)
{
    return -(a-b)*d+a;
}

vec3 gradient(float c)
{
    vec4 cols[4];
    
    //                 r          g         b      position on gradient space (0 and 1 required)
    cols[0] = vec4(255./255., 193./255., 36./255., 0.0);
    cols[1] = vec4(182./255., 255./255., 36./255., 0.3);
    cols[2] = vec4(255./255.,  76./255., 36./255., 0.6);
    cols[3] = vec4(255./255., 200./255., 36./255., 1.0);
    
    
    // pick two colors that are on the sides of a sample
    int i = 0;
    while(!(c >= cols[i].w && c <= cols[i+1].w))
    {
        i++;
    }
    
    vec4 Bcol = cols[i];
    vec4 Tcol = cols[i+1];
    
    // transform them to bottomColor-0.0 and topColor-1.0
    c -= Bcol.w;
    Tcol.w -= Bcol.w;
    Bcol.w -= Bcol.w;

    c /= Tcol.w;
    Bcol.w /= Tcol.w;
    Tcol.w /= Tcol.w;


    // interpolate color
    vec3 outcome;
    outcome.x = interpolate(Bcol.x, Tcol.x, c);
    outcome.y = interpolate(Bcol.y, Tcol.y, c);
    outcome.z = interpolate(Bcol.z, Tcol.z, c);
    
    return outcome;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (fragCoord/iResolution.xy + vec2(-.35, -.2)) * vec2(1.7);
    uv.x *= iResolution.x/iResolution.y;

    float size = 1./ 0.04; // change size

    uint rN = uint(4);  // seed value (change for different trajectories and colors)

    float d = 0.;     // sum of 1/dist for all balls
    vec3 col = vec3(0);

    float cd[nBalls];     // 1/dist^2 for all balls 
    vec2 balls[nBalls];   // positions
    vec3 colors[nBalls];  // colors
    float total=0.;       // sum of cds
    
    for(int i = 0; i < nBalls; i++) // initialize balls
    {
        balls[i] = vec2(r(rN) + r(rN + uint(1))*sin(r(rN + uint(2)) + iTime*r(rN + uint(3))), r(rN + uint(4)) + r(rN + uint(5))*.6*sin(r(rN + uint(6)) + iTime*r(rN + uint(7))));
        //colors[i] = vec3(r(rN + uint(8)), r(rN + uint(9)), r(rN + uint(10)));
        //colors[i] /= vec3(max(colors[i].x, max(colors[i].y, colors[i].z)));
        colors[i] = gradient(r(rN + uint(8)));
        rN += uint(100);
    }
    

    for(int i = 0; i < nBalls; i++) // distances for interpolation of colors
    {
        float dist = length(balls[i]-uv);
        d += 1./dist * (.6+r(rN+uint(100))*.4);

        if(dist == 0.) col = colors[i];

        float oneover = 1./pow(dist, 4.);

        cd[i] = oneover;
        total += oneover;

        rN += uint(100);
    }

    
    //if(d > size-.5)   // no background
    //if(d < size+1.5)  // border mode
    //{
        for(int i = 0; i < nBalls; i++)  // interpolation of colors based on distances
        {
            float ratio = cd[i] / total;
            col.x += ratio * colors[i].x;
            col.y += ratio * colors[i].y;
            col.z += ratio * colors[i].z;
        }
    //}

    
    
    if(iMouse.z > .5)   // coloring modes
        col = vec3(smoothstep(size-11., size, d), smoothstep(size-6., size, d), smoothstep(size-30., size, d));
    else
        col *= vec3(.3+.73*smoothstep(size-0.5, size, d));

    fragColor = vec4(col,1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

